/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.Stack;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.reader.MergeTopicParser;
import org.dita.dost.util.AttributeStack;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class MergeMapParser
extends XMLFilterImpl {
    private static final String ATTRIBUTE_NAME_FIRST_TOPIC_ID = "first_topic_id";
    public static final String ATTRIBUTE_NAME_OHREF = "ohref";
    public static final String ATTRIBUTE_NAME_OID = "oid";
    private final MergeTopicParser topicParser;
    private final MergeUtils util;
    private File dirPath = null;
    private File tempdir = null;
    private final Stack<String> processStack = new Stack();
    private final AttributeStack attributeStack = new AttributeStack("processing-role", "scope", "format");
    private int processLevel = 0;
    private final ByteArrayOutputStream topicBuffer;
    private final SAXTransformerFactory stf;
    private OutputStream output;
    private DITAOTLogger logger;
    private Job job;

    public MergeMapParser() {
        this.util = new MergeUtils();
        this.topicParser = new MergeTopicParser(this.util);
        this.topicBuffer = new ByteArrayOutputStream();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            if (!tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw new RuntimeException("SAX transformation factory not supported");
            }
            this.stf = (SAXTransformerFactory)tf;
            TransformerHandler s = this.stf.newTransformerHandler();
            s.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
            s.setResult(new StreamResult(this.topicBuffer));
            this.topicParser.setContentHandler(s);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize XML parser: " + e.getMessage(), e);
        }
    }

    public final void setLogger(DITAOTLogger logger) {
        this.logger = logger;
        this.util.setLogger(logger);
        this.topicParser.setLogger(logger);
    }

    public final void setJob(Job job) {
        this.job = job;
        this.util.setJob(job);
        this.topicParser.setJob(job);
    }

    public void setOutput(File outputFile) {
        this.topicParser.setOutput(outputFile);
    }

    public void setOutputStream(OutputStream output) {
        this.output = output;
    }

    public void read(File filename, File tmpDir) {
        this.tempdir = tmpDir != null ? tmpDir : filename.getParentFile();
        try {
            TransformerHandler s = this.stf.newTransformerHandler();
            s.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
            s.setResult(new StreamResult(this.output));
            this.setContentHandler(s);
            this.dirPath = filename.getParentFile();
            this.topicParser.getContentHandler().startDocument();
            this.logger.info("Processing " + String.valueOf(filename.toURI()));
            this.job.getStore().transform(filename.toURI(), this);
            this.topicParser.getContentHandler().endDocument();
            this.output.write(this.topicBuffer.toByteArray());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.processLevel > 0) {
            String value = this.processStack.peek();
            if (this.processLevel == this.processStack.size()) {
                value = this.processStack.pop();
            }
            --this.processLevel;
            if ("resource-only".equals(value)) {
                this.attributeStack.pop();
                return;
            }
        }
        this.getContentHandler().endElement(uri, localName, qName);
        this.attributeStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.processStack.empty() || !"resource-only".equals(this.processStack.peek())) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        URI attValue;
        this.attributeStack.push(attributes);
        String attrValue = attributes.getValue("processing-role");
        if (attrValue != null) {
            this.processStack.push(attrValue);
            ++this.processLevel;
            if ("resource-only".equals(attrValue)) {
                return;
            }
        } else if (this.processLevel > 0) {
            ++this.processLevel;
            if ("resource-only".equals(this.processStack.peek())) {
                return;
            }
        }
        Attributes atts = null;
        if (Constants.MAP_TOPICREF.matches(attributes) && (attValue = URLUtils.toURI(attributes.getValue("href"))) != null) {
            atts = new AttributesImpl(attributes);
            String scope = this.attributeStack.peek("scope");
            String format = this.attributeStack.peek("format");
            if (DitaUtils.isLocalScope(scope) && DitaUtils.isDitaFormat(format)) {
                URI ohref = attValue;
                URI copyToValue = URLUtils.toURI(((AttributesImpl)atts).getValue("copy-to"));
                if (copyToValue != null && !copyToValue.toString().isEmpty()) {
                    attValue = copyToValue;
                }
                URI absTarget = URLUtils.toDirURI(this.dirPath).resolve(attValue);
                XMLUtils.addOrSetAttribute((AttributesImpl)atts, ATTRIBUTE_NAME_OHREF, ohref.toString());
                if (this.util.isVisited(absTarget)) {
                    attValue = URLUtils.toURI("#" + this.util.getIdValue(absTarget));
                } else {
                    URI p = URLUtils.stripFragment(attValue).normalize();
                    this.util.visit(absTarget);
                    File f = new File(URLUtils.stripFragment(absTarget));
                    if (this.job.getStore().exists(f.toURI())) {
                        this.topicParser.parse(URLUtils.toFile(p).getPath(), this.dirPath);
                        String fileId = this.topicParser.getFirstTopicId();
                        if (this.util.getIdValue(absTarget) == null) {
                            this.util.addId(absTarget, fileId);
                        }
                        if (attValue.getFragment() != null && this.util.getIdValue(URLUtils.stripFragment(absTarget)) == null) {
                            this.util.addId(URLUtils.stripFragment(absTarget), fileId);
                        }
                        URI firstTopicId = URLUtils.toURI("#" + fileId);
                        attValue = this.util.getIdValue(absTarget) != null ? URLUtils.toURI("#" + this.util.getIdValue(absTarget)) : firstTopicId;
                        XMLUtils.addOrSetAttribute((AttributesImpl)atts, ATTRIBUTE_NAME_FIRST_TOPIC_ID, firstTopicId.toString());
                    } else {
                        URI fileName = URLUtils.toDirURI(this.dirPath).resolve(attValue);
                        this.logger.error(MessageUtils.getMessage("DOTX008E", fileName.toString()).setLocation(attributes).toString());
                    }
                }
            }
            XMLUtils.addOrSetAttribute((AttributesImpl)atts, "href", attValue.toString());
        }
        this.getContentHandler().startElement(uri, localName, qName, atts != null ? atts : attributes);
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            for (Job.FileInfo f : this.job.getFileInfo()) {
                URI abs;
                if (!f.isTarget) continue;
                String element = f.file.getPath();
                if (!this.dirPath.equals(this.tempdir)) {
                    element = FileUtils.getRelativeUnixPath(new File(this.dirPath, "a.ditamap").getAbsolutePath(), this.tempdir.toPath().resolve(element).toAbsolutePath().toString());
                }
                if (this.util.isVisited(abs = this.job.tempDirURI.resolve(f.uri))) continue;
                this.util.visit(abs);
                if (f.isResourceOnly) continue;
                File file = this.dirPath.toPath().resolve(element).toFile();
                if (this.job.getStore().exists(file.toURI())) {
                    this.topicParser.parse(element, this.dirPath);
                    continue;
                }
                String fileName = file.getAbsolutePath();
                this.logger.debug(MessageUtils.getMessage("DOTX008E", fileName).toString());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        this.getContentHandler().endDocument();
    }
}

