/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Add dynamic dependency for mingw TC for Android packages on Windows.
    if (installer.value("os") == "win") {
        var mingw_tc_component = "qt.tools.win64_mingw900"
        component.addDependency(mingw_tc_component);
    }

    // add automatic dependency to Android main node if it's selected
    dependencyStr = "qt.qt6.672.android"

    // For release builds set the dependency directly to the host binary
    var hostDependencyStr = "";
    if (installer.value("os") == "x11") {
        // Linux on ARM supported from Qt 6.7 onward
        if ("672" == "dev" || 67 >= 67) {
            if (systemInfo.currentCpuArchitecture == "arm64") {
                hostDependencyStr = "qt.qt6.672.linux_gcc_arm64"
            }
            else {
                hostDependencyStr = "qt.qt6.672.linux_gcc_64"
            }
        }
        else {
            hostDependencyStr = "qt.qt6.672.gcc_64"
        }
    }
    else if (installer.value("os") == "mac") {
        hostDependencyStr = "qt.qt6.672.clang_64"
    }
    else if (installer.value("os") == "win") {
        hostDependencyStr = "qt.qt6.672.win64_mingw"
    }
    component.addDependency(hostDependencyStr);

    // Set automatic dependencies
    // - for release builds add dependency to the main Android node
    component.addAutoDependOn(dependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    qtExecuteGenericPatching_672("Windows-Windows_10_22H2-Clang-Android-Android_ANY-ARMv7", "armv7", "/6.7.2/android_armv7", component.value("Name"));

    qtExecuteAndroidPatching_672(component.value("Name"), "ARMv7", "/6.7.2/android_armv7");
}

