/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.base.Function;
import com.squareup.haha.guava.base.Predicate;
import com.squareup.haha.guava.base.Predicates;
import com.squareup.haha.guava.collect.AbstractIndexedListIterator;
import com.squareup.haha.guava.collect.Collections2;
import com.squareup.haha.guava.collect.TransformedIterator;
import com.squareup.haha.guava.collect.UnmodifiableIterator;
import com.squareup.haha.guava.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public final class Iterators {
    private static UnmodifiableListIterator<Object> EMPTY_LIST_ITERATOR = new UnmodifiableListIterator<Object>(){

        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public final boolean hasPrevious() {
            return false;
        }

        @Override
        public final Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public final int nextIndex() {
            return 0;
        }

        @Override
        public final int previousIndex() {
            return -1;
        }
    };
    private static final Iterator<Object> EMPTY_MODIFIABLE_ITERATOR = new Iterator<Object>(){

        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            Ascii.checkRemove(false);
        }
    };

    public static <T> UnmodifiableIterator<T> emptyIterator() {
        return EMPTY_LIST_ITERATOR;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EMPTY_MODIFIABLE_ITERATOR;
    }

    public static boolean contains(Iterator<?> iterator, @Nullable Object element) {
        int n;
        block3: {
            Predicate<Object> predicate = Predicates.equalTo(element);
            Iterator<?> iterator2 = iterator;
            Predicate<Object> predicate2 = predicate;
            Iterator<?> iterator3 = iterator2;
            String string = "predicate";
            Predicate<Object> predicate3 = predicate2;
            if (predicate3 == null) {
                throw new NullPointerException(String.valueOf(string));
            }
            int n2 = 0;
            while (iterator3.hasNext()) {
                Object obj = iterator3.next();
                if (predicate2.apply(obj)) {
                    n = n2;
                    break block3;
                }
                ++n2;
            }
            n = -1;
        }
        return n != -1;
    }

    public static boolean removeAll(Iterator<?> removeFrom, Collection<?> elementsToRemove) {
        return Iterators.removeIf(removeFrom, Predicates.in(elementsToRemove));
    }

    public static <T> boolean removeIf(Iterator<T> removeFrom, Predicate<? super T> predicate) {
        Ascii.checkNotNull(predicate);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!predicate.apply(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return modified;
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (Ascii.equal(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        return Collections2.STANDARD_JOINER$5f22bbb7.appendTo(new StringBuilder("["), iterator).append(']').toString();
    }

    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        Ascii.checkNotNull(addTo);
        Ascii.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> inputs) {
        Ascii.checkNotNull(inputs);
        return new Iterator<T>(inputs){
            private Iterator<? extends T> current = Iterators.emptyIterator();
            private Iterator<? extends T> removeFrom;
            private /* synthetic */ Iterator val$inputs;
            {
                this.val$inputs = iterator;
            }

            @Override
            public final boolean hasNext() {
                boolean currentHasNext;
                while (!(currentHasNext = Ascii.checkNotNull(this.current).hasNext()) && this.val$inputs.hasNext()) {
                    this.current = (Iterator)this.val$inputs.next();
                }
                return currentHasNext;
            }

            @Override
            public final T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeFrom = this.current;
                return this.current.next();
            }

            @Override
            public final void remove() {
                Ascii.checkRemove(this.removeFrom != null);
                this.removeFrom.remove();
                this.removeFrom = null;
            }
        };
    }

    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, Function<? super F, ? extends T> function) {
        Ascii.checkNotNull(function);
        return new TransformedIterator<F, T>(fromIterator, function){
            private /* synthetic */ Function val$function;
            {
                this.val$function = function;
                super(x0);
            }

            @Override
            final T transform(F from) {
                return this.val$function.apply(from);
            }
        };
    }

    @Nullable
    public static <T> T getNext(Iterator<? extends T> iterator, @Nullable T defaultValue) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return defaultValue;
    }

    @Nullable
    static <T> T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            T result = iterator.next();
            iterator.remove();
            return result;
        }
        return null;
    }

    static void clear(Iterator<?> iterator) {
        Ascii.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    static <T> UnmodifiableListIterator<T> forArray(T[] array, int offset, int length, int index) {
        Ascii.checkArgument(length >= 0);
        int end = offset + length;
        Ascii.checkPositionIndexes(offset, end, array.length);
        Ascii.checkPositionIndex(index, length);
        if (length == 0) {
            return EMPTY_LIST_ITERATOR;
        }
        return new AbstractIndexedListIterator<T>(length, index, array, offset){
            private /* synthetic */ Object[] val$array;
            private /* synthetic */ int val$offset;
            {
                this.val$array = objectArray;
                this.val$offset = n;
                super(x0, x1);
            }

            @Override
            protected final T get(int index) {
                return this.val$array[this.val$offset + index];
            }
        };
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(@Nullable T value) {
        return new UnmodifiableIterator<T>(value){
            private boolean done;
            private /* synthetic */ Object val$value;
            {
                this.val$value = object;
            }

            @Override
            public final boolean hasNext() {
                return !this.done;
            }

            @Override
            public final T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return this.val$value;
            }
        };
    }

    static <T> ListIterator<T> cast(Iterator<T> iterator) {
        return (ListIterator)iterator;
    }
}

