/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import java.util.Collections;
import java.util.Set;

public abstract class Check
extends AbstractViolationReporter {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private FileContents fileContents;
    private final Set<String> tokens = Sets.newHashSet();
    private LocalizedMessages messages;
    private int tabWidth = 8;
    private ClassLoader loader;

    public boolean isCommentNodesRequired() {
        return false;
    }

    public abstract int[] getDefaultTokens();

    public int[] getAcceptableTokens() {
        int[] defaultTokens = this.getDefaultTokens();
        int[] copy = new int[defaultTokens.length];
        System.arraycopy(defaultTokens, 0, copy, 0, defaultTokens.length);
        return copy;
    }

    public int[] getRequiredTokens() {
        return new int[0];
    }

    public final void setTokens(String[] strRep) {
        Collections.addAll(this.tokens, strRep);
    }

    public final Set<String> getTokenNames() {
        return this.tokens;
    }

    public final void setMessages(LocalizedMessages messages) {
        this.messages = messages;
    }

    public void init() {
    }

    public void destroy() {
    }

    public void beginTree(DetailAST rootAST) {
    }

    public void finishTree(DetailAST rootAST) {
    }

    public void visitToken(DetailAST ast) {
    }

    public void leaveToken(DetailAST ast) {
    }

    public final String[] getLines() {
        return this.getFileContents().getLines();
    }

    public final String getLine(int index) {
        return this.getFileContents().getLine(index);
    }

    public final void setFileContents(FileContents contents) {
        this.fileContents = contents;
    }

    public final FileContents getFileContents() {
        return this.fileContents;
    }

    public final void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public final ClassLoader getClassLoader() {
        return this.loader;
    }

    protected final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.messages.add(new LocalizedMessage(line, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        int col = 1 + Utils.lengthExpandedTabs(this.getLines()[lineNo - 1], colNo, this.getTabWidth());
        this.messages.add(new LocalizedMessage(lineNo, col, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }
}

