<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>


<?php
if (isset($display) && $display == "edit_topic") {
?>
<form action="frm_edit.php" method="post" name="frm" id="id_frm">
<input type="hidden" name="topic_id" value="<?php if(isset($topic['topic_id'])) {  echo $topic['topic_id'];}?>" />

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_topics'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<table border="0" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td>
						<b><?php echo $lang['hdr_edit_topic'];?></b><br />
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="12" alt="" /><br />
					</td>
					<td colspan="2">
						<br />
					</td>
				</tr>
				<tr>
					<td valign="top">
						<fieldset>
						<legend><?php echo $lang['txt_header_1'];?></legend>
						<p>
						<?php echo $lang['txt_topic_intro'];?><br />
						</p>
					
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<?php 
						if (isset($topics)) {
						?>
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<?php
							foreach($topics as $key => $i): ?>
							<tr>
								<td valign="top">
									<a href="frm_edit.php?topic_id=<?php echo $i['topic_id'];?>"><?php echo $i['topic_title'];?></a><br />
								</td>
								<td valign="top">
									<?php echo $i['topic_synopsis'];?><br />
								</td>
								<td align="right" valign="top">
									<?php if ($i['topic_hidden'] == 1) { echo $lang['txt_hidden'];}?><br />
								</td>
								<td valign="top">
									<?php echo $i['topic_order'];?><br />
								</td>
							</tr>
							<?php 
							endforeach; 
							?>
						</table>
						<?
						}
						else {
						?>
						<p>
						<?php echo $lang['err_no_topics'];?><br />
						</p>
						<?php }?>
						<p align="right">
							<br />
							<a href="frm_edit.php?add_topic=1" class="link_urgent"><?php echo $lang['href_add_item'];?></a><br />
						</p>
						</fieldset>
					</td>
					<td width="20">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="20" height="1" alt="" /><br />
					</td>
					<td width="280">
						<fieldset>
						<legend><?php echo $lang['txt_header_2'];?></legend>
						<p>
						<?php echo $lang['txt_topic_edit_intro'];?><br />
						</p>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<p>
						<label for="id_topic_title"><?php echo $lang['txt_topic_title'];?></label>
						<input id="id_topic_title" type="text" name="topic_title" size="25" value="<?php if (isset($topic['topic_title'])) { echo $topic['topic_title'];}?>" /><br />
						</p>
						
						<p>
						<label for="id_topic_synopsis"><?php echo $lang['txt_topic_synopsis'];?></label>
						<textarea id="id_topic_synopsis" name="topic_synopsis" maxlength="255" cols="22" rows="2"><?php if (isset($topic['topic_synopsis'])) { echo $topic['topic_synopsis'];}?></textarea><br />
						</p>
						
						<?php
						if ($this->user_acs->checkPermission($resource_ids['forum'], $privilege_ids['allow_hidden'])) { //resource_id, Priv_id
						?>
						<p>
						<label for="id_hidden"><?php echo $lang['txt_hidden'];?></label>
						<input id="id_hidden" type="checkbox" name="topic_hidden" class="checkbox" value="1" <?php if (isset($topic['topic_hidden']) && $topic['topic_hidden'] == 1) { echo "checked=\"checked\"";}?> /><br />
						</p>
						<?php  }?>
								
						<p>
						<label for="id_topic_order"><?php echo $lang['form_label_topic_order'];?></label>
						<input id="id_topic_order" type="text" name="topic_order" size="4" value="<?php if (isset($topic['topic_order'])) { echo $topic['topic_order'];}?>" /><br />
						</p>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<p>
						<?php echo $lang['txt_topic_roles'];?><br />
						</p>
						
						<table cellpadding="4" cellspacing="0" border="0">
							<?php
							if (isset($lang['arr_acs']['role'])) {
							foreach($lang['arr_acs']['role'] as $key => $i):
								$selected = "";
								if (isset($topic_roles)) {
									foreach($topic_roles as $key1 => $tr):
										if ($tr['role_id'] == $key) {
											$selected = "checked=\nchecked\n";
											break;
										}
									endforeach;
								}
							?>
							<tr>
								<td valign="top">
									<input type="checkbox" name="role_ids[]" value="<?php echo $key;?>" <?php echo $selected;?> /><br />
								</td>
								<td valign="top">
									<?php echo $i;?><br />
								</td>
							</tr>
							<?php
							endforeach;
							}
							?>
						</table>
						</fieldset>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />
						
						<fieldset>
						<legend><?php echo $lang['txt_header_5'];?></legend>
						<p>
						<?php echo $lang['txt_save_intro'];?><br />
						</p>
					
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<input type="submit" name="save_topic" class="button_urgent" value="<?php echo $lang['sub_save'];?>" />&nbsp;
						<input type="submit" name="save_go_topic" class="button_urgent" value="<?php echo $lang['sub_save_go'];?>" />
						
						<?php
						if (isset($topic['total_subjects']) && $topic['total_subjects'] == 0) {
						?>
						&nbsp;
						<input type="submit" name="delete_topic" class="button_urgent" value="<?php echo $lang['form_submit_delete'];?>" />
						<?php }?>
						<br />
						</fieldset>
					</td>
				</tr>
			</table>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</form>

<?php
}
elseif (isset($display) && $display == "edit_subject") {
?>
<script language="JavaScript" src="js/imageHandling.js" type="text/javascript"></script>

<form action="frm_edit.php" method="post" name="frm" id="id_frm">
<input type="hidden" name="topic_id" value="<?php if(isset($topic['topic_id'])) {  echo $topic['topic_id'];}?>" />
<input type="hidden" name="subject_id" value="<?php if(isset($subject['subject_id'])) {  echo $subject['subject_id'];}?>" />

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_update'];?><br />
	</div>
	
	<div class="box_mid">
		<div class="content">
			<table border="0" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td>
						<b>
						<?php echo $lang['hdr_subject'];?></b><br />
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="12" alt="" /><br />
						
					</td>
					<td colspan="2">
						<br />
					</td>
				</tr>
				<tr>
					<td valign="top">
						<fieldset>
						<legend><?php echo $lang['txt_header_1'];?></legend>
						<p>
						<?php echo $lang['txt_overview_intro'];?><br />
						</p>
					
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<table border="0" cellspacing="0" cellpadding="0" width="100%">
							<tr>
								<td valign="top" width="310">
									<p>
									<label for="id_subject_title"><?php echo $lang['form_label_title'];?></label>
									<input id="id_subject_title" type="text" name="subject_title" size="35" value="<?php if (isset($subject['subject_title'])) { echo $subject['subject_title'];}?>" /><br />
									</p>
									
									<p>
									<label for="id_subject_synopsis"><?php echo $lang['form_label_synopsis'];?></label>
									<textarea id="id_subject_synopsis" name="subject_synopsis" cols="32" rows="2"><?php if (isset($subject['subject_synopsis'])) { echo $subject['subject_synopsis'];}?></textarea><br />
									</p>
									
									<p>
									<label for="id_subject_title">
									<?php echo $lang['txt_topic'];?></label>
									<select id="id_subject_title" name="topic_id">
									<?php
									foreach($topics as $key => $i):
									$selected = "";
			
									if ($subject['topic_id'] == $i['topic_id'] || $topic['topic_id'] == $i['topic_id']) {
										$selected = "selected";
									}
									?>
									<option value="<?php echo $i['topic_id'];?>" <?php echo $selected;?>><?php echo $i['topic_title'];?></option>
									<?php endforeach; ?>
									</select>
									</p>
								</td>
								<td>
									<img src="<?php echo $templatePath;?>img/pixel.png" width="10" height="1" alt="" /><br />
								</td>
								<td valign="top">
									<?php
									if ($this->user_acs->checkPermission($resource_ids['forum'], $privilege_ids['allow_locking'])) { //resource_id, Priv_id
									?>
									<p>
									<label for="id_subject_locked"><?php echo $lang['txt_locked'];?></label>
									<input id="id_subject_locked" type="checkbox" class="checkbox" name="subject_locked" value="1" <?php if (isset($subject['subject_locked']) && $subject['subject_locked'] == 1) { echo "checked=\"checked\"";}?> /><br />
									</p>
									<?php }?>
									<p>
									<label for="id_subject_sticky"><?php echo $lang['txt_sticky'];?></label>
									<input id="id_subject_sticky" type="checkbox" class="checkbox" name="subject_sticky" value="1" <?php if (isset($subject['subject_sticky']) && $subject['subject_sticky'] == 1) { echo "checked=\"checked\"";}?> /><br />
									</p>
									
									<?php
									if ($this->user_acs->checkPermission($resource_ids['forum'], $privilege_ids['allow_hidden'])) { //resource_id, Priv_id
									?>
									<p>
									<label for="id_subject_hidden"><?php echo $lang['txt_hidden'];?></label>
									<input id="id_subject_hidden" type="checkbox" class="checkbox" name="subject_hidden" value="1" <?php if (isset($subject['subject_hidden']) && $subject['subject_hidden'] == 1) { echo "checked=\"checked\"";}?> /><br />
									</p>
									<?php  }?>
								</td>
							</tr>
						</table>
						</fieldset>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<fieldset>
						<legend><?php echo $lang['txt_header_2'];?></legend>
						<p>
						<?php echo $lang['txt_detail_intro'];?><br />
						</p>
					
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<table border="0" cellspacing="0" cellpadding="2" width="10%">
							<tr>
								<td valign="top">
									<label for="id_subject_body"><?php echo $lang['form_body'];?></label><br />
								</td>
								<td valign="middle" id="gui_wiki" align="right" nowrap="nowrap">
									<script language="JavaScript" type="text/javascript" src="js/gui_wiki.js"></script>&nbsp;<br />
								</td>
								<td width="1" valign="top">
									<select class="gui_select" onChange="javascript:insertTags('[', ' link name here]', this.value);">
										<option value="0"><?php echo $lang['txt_wikipagenames'];?></option>
										<?php
										if (isset($wikipages)) {
										foreach($wikipages as $key => $i):
										?>
										<option><?php echo $i;?></option>
										<?php
										endforeach;
										}
										?>
									</select>
									<br />
								</td>
								<td width="1">
									<script language="JavaScript" type="text/javascript">
									function fileSuffixCheck (filename) {
										
										var suffix = filename.substring(filename.length-3);
										
										if (suffix=='jpg' || suffix=='png' || suffix=='gif') {
											var wikiTag = "Image ";
											var thumb = "";
										}
										else {
											var wikiTag = "File ";
											var thumb = " thumb=1";
										}
										
										insertTags('[['+wikiTag , filename+thumb+']]', '')
									}
									</script>
									
									<select class="gui_select" onChange="javascript:fileSuffixCheck(this.value);">
										<option value="0"><?php echo $lang['txt_filenames'];?></option>
										<?php
										if (isset($filenames)) {
										foreach($filenames as $key => $i):
										?>
										<option><?php echo $i['file_name'] . "." . $i['file_suffix'];?></option>
										<?php
										endforeach;
										}
										?>
									</select>
									<br />
								</td>
							</tr>
							<tr>
								<td colspan="4">
									<textarea id="id_subject_body" name="subject_body" cols="75" rows="10" onchange="textChanged = true;" tabindex="1"><?php if (isset($subject['subject_body'])) { echo $subject['subject_body'];}?></textarea><br />
									<script language="JavaScript" type="text/javascript">
										var txtarea = document.frm.subject_body;
									</script>
								</td>
							</tr>
							<tr>
								<td align="right" colspan="4">
									<?php 
									if (isset($allow_spellcheck)) {
									?>
									&nbsp;&nbsp;
									<input type="button" value="<?php echo $lang['sub_check_spelling'];?>" onClick="openSpellChecker();" class="button_light" />
									<?php }?>
									<br />
								</td>
							</tr>
							
							<?php
							if (!empty($subject['subject_body_preview'])) {
							?>
							
							<tr>
								<td>
									<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
								</td>
							</tr>
							<tr>
								<td>
									<?php echo $lang['form_label_preview'];?><br />
								</td>
							</tr>
							<tr>
								<td class="picture_light">
									<?php echo $subject['subject_body_preview'];?><br />
								</td>
							</tr>
							<?php }?>
						</table>
						</fieldset>
						
					</td>
					<td>
						<img src="<?php echo $templatePath;?>img/pixel.png" width="10" height="1" alt="" /><br />
					</td>
					<td valign="top" width="200">
						<fieldset>
						<legend><?php echo $lang['txt_header_3'];?></legend>
						<p>
						<?php echo $lang['txt_image_intro'];?><br />
						</p>
					
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<?php
						if (isset($images)) {
						?>
						<p>
						<?php echo $lang['form_label_file'];?></label><br />
						</p>	
						
						<div>
						<p>
						<select id="id_file_id" size="4" name="file_id" onChange='javascript:setimg(this)'>
						<option value="0" selected="selected"><?php echo $lang['txt_none'];?></option>
						<?php
						$img_divs = "";
						foreach($images as $key => $i):
						$display_state = "none";
						$selected = "";
						if (isset($subject['file_id']) && $subject['file_id'] == $i['file_id']) {
							$selected = "selected=\"selected\"";
							$display_state = "block";
						}
						?>
						<option value="<?php echo $i['file_id'];?>" <?php echo $selected;?>><?php echo $i['file_name'];?></option>
						<?php
						$img_divs .= "<div style=\"display:" . $display_state . ";\" id=img" . $i['file_id'] . "><img src=\"get_file.php?file=" . $i['file'] . "\" border=\"0\" class=\"picture\" /><br />" . $i['file_title'] . "</div>";
						endforeach;
						?>
						</select>
						</p>
						</div>
						<?php echo $img_divs;?>
						<?php }?>
						</fieldset>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />
						
						<fieldset>
						<legend><?php echo $lang['txt_header_4'];?></legend>
						<p>
						<?php echo $lang['txt_publishing_intro'];?><br />
						</p>
					
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<?php
						//find out what value rsp has
						if (isset($subject['rsp'])) {
							foreach($subject['rsp'] as $key => $rsp):
								if ($rsp['level_id'] == $rspconfig['rsp_level']['degree']) {
									$rsp_degree_set = 1;
									$rsp_degree = $rsp['degree_id'];
								}
								elseif ($rsp['level_id'] == $rspconfig['rsp_level']['node']) {
									$rsp_node = 1;
								}
								elseif ($rsp['level_id'] == $rspconfig['rsp_level']['public']) {
									$rsp_public = 1;
								}
							endforeach;
						}
						?>
						
						<script type="text/javascript">
						function setDegreeEveryone(id) {
							if (id.checked) {
								document.getElementById('id_degree_id').checked=true;
							}
						}
						function setPublishingOff() {
							document.getElementById('id_level_id_node').checked=false;
							document.getElementById('id_level_id_public').checked=false;
							
						}
						</script>
						
						<table border="0" cellspacing="0" cellpadding="2" width="100%">
							<tr>
								<td width="1">
									<input type="radio" class="checkbox" name="rsp_degree" value="" checked="checked" onClick="javascript:setPublishingOff();" /><br />
								</td>
								<td>
									<?php echo $lang['form_just_me'];?><br />
								</td>
							</tr>
							
							
							<?php
							if ($this->user_acs->checkPermission($resource_ids['rsp'], $privilege_ids['allow_rsp_network'])) { //resourece_id, Priv_id
							$selected="";
							if (isset($rsp_degree)) {
								$selected=" checked=\"checked\"";
							}
							?>
							<tr>
								<td width="1">
									<input type="radio" name="rsp_degree" class="checkbox" value="1"<?php echo $selected;?> onClick="javascript:setPublishingOff();" /><br />
								</td>
								<td>
									<?php echo $lang['txt_degree_nw'];?><br />
								</td>
							</tr>
							<?php }?>
							
							<?php
							$selected="";
							if (isset($rsp_degree_set) && empty($rsp_degree)) {
								$selected=" checked=\"checked\"";
							}
							?>
							<tr>
								<td>
									<input id="id_degree_id" type="radio" class="checkbox" name="rsp_degree" value="all"<?php echo $selected;?> /><br />
								</td>
								<td>
									<?php echo $lang['txt_publish_all'];?><br />
								</td>
							</tr>
							
							<?php
							if ($this->user_acs->checkPermission($resource_ids['rsp'], $privilege_ids['allow_rsp_node'])) { //resourece_id, Priv_id
							$selected="";
							if (isset($rsp_node) && $rsp_node == 1) {
								$selected=" checked=\"checked\"";
							}
							?>
							<tr>
								<td valign="top">
									<input type="checkbox" id="id_level_id_node" name="rsp_node" value="1"<?php echo $selected;?> class="checkbox" onChange="javascript:setDegreeEveryone(this);" /><br />
								</td>
								<td>
									<?php 
									if (isset($rspconfig['node']['auto_publish'])) {
										echo $lang['txt_publish_auto_node_help'];
									}
									else {
										echo $lang['txt_publish_node_help'];
									}
									?><br />
								</td>
							</tr>
							<?php
							}
							
							if ($this->user_acs->checkPermission($resource_ids['rsp'], $privilege_ids['allow_rsp_public'])) { //resourece_id, Priv_id
							$selected="";
							if (isset($rsp_public) && $rsp_public == 1) {
								$selected=" checked=\"checked\"";
							}
							?>
							<tr>
								<td valign="top">
									<input type="checkbox" id="id_level_id_public" name="rsp_public" value="1"<?php echo $selected;?> class="checkbox" onChange="javascript:setDegreeEveryone(this);" /><br />
								</td>
								<td>
									<?php 
									if (isset($rspconfig['node']['auto_publish'])) {
										echo $lang['txt_publish_auto_public_help'];
									}
									else {
										echo $lang['txt_publish_public_help'];
									}
									?><br />
								</td>
							</tr>
							<?php }?>
						</table>
						</fieldset>
						
						<script type="text/javascript">
						//check php did not set either of the publishing buttons
						if (document.getElementById('id_level_id_node').checked) {
							document.getElementById('id_degree_id').checked=true;
						}
						</script>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="9" alt="" /><br />
						
						<fieldset>
						<legend><?php echo $lang['txt_header_5'];?></legend>
						<p>
						<?php echo $lang['txt_save_intro'];?><br />
						</p>
					
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="6" alt="" /><br />
						
						<input type="submit" name="save_subject" class="button_urgent" value="<?php echo $lang['sub_save'];?>" />&nbsp;
						<input type="submit" name="save_go_subject" class="button_urgent" value="<?php echo $lang['sub_save_go'];?>" /><br />
					
						</fieldset>
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
</form>
<?php
}
else { //no edit allowed
?>
<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_subjects'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_item_edit'];?><br />
			</div>
		</div>
	</div>
</div>
	
<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
<?php }?>