// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.h>
#include <pygil.h>
#include <mobius/crypt/pkcs5.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief pbkdf2_hmac function implementation
//! \param self function object
//! \param args argument list
//! \return Python object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
func_pbkdf2_hmac (PyObject *, PyObject *args)
{
  // parse input args
  const std::uint8_t *arg_key_buffer;
  Py_ssize_t arg_key_size;
  const std::uint8_t *arg_salt_buffer;
  Py_ssize_t arg_salt_size;
  unsigned long arg_iterations = 0;
  unsigned int arg_dklen = 0;
  const char *arg_hash_id = "sha1";

  if (!PyArg_ParseTuple (args, "ss#s#LI", &arg_hash_id, &arg_key_buffer, &arg_key_size, &arg_salt_buffer, &arg_salt_size, &arg_iterations, &arg_dklen))
    return nullptr;

  mobius::bytearray arg_key (arg_key_buffer, arg_key_size);
  mobius::bytearray arg_salt (arg_salt_buffer, arg_salt_size);

  // execute C++ function
  PyObject *ret = nullptr;

  try
    {
      auto dk = mobius::py::GIL () (
		  mobius::crypt::pbkdf2_hmac (
                    arg_hash_id,
                    arg_key,
                    arg_salt,
                    arg_iterations,
                    arg_dklen
                  )
                );
      ret = mobius::py::pybytes_from_bytearray (dk);
    }
  catch (const std::exception& e)
    {
      PyErr_SetString (PyExc_IOError, e.what ());
    }

  // return value
  return ret;
}
